package com.ethon.tools;

import java.awt.Color;

import com.ethon.DataBase;
import com.ethon.mode.DataPoint;

public class CounterUtil {
	/**
	 * ꣬ǵľƽ
	 * @param coord_X1еһx
	 * @param coord_Y1еһy
	 * @param coord_X2еڶx
	 * @param coord_Y2еڶy
	 * @return֮ŷʽ
	 */
	public double getDistance2(double coord_X1, double coord_Y1, double coord_X2, double coord_Y2){
		double x=coord_X1-coord_X2;
		double y=coord_Y1-coord_Y2;
		
		return x*x+y*y;
	}
	
	/**
	 * 㣨ԴӰ㣩ʵԼԴȨֵԴӰֵ
	 * @param coord_Source_XԴx
	 * @param coord_Source_YԴy
	 * @param weightԴȨ
	 * @param coord_XӰx
	 * @param coord_YӰy
	 * @param sigmaӰ
	 * @returnԴӰֵ
	 */
	public double getPotential(double coord_Source_X, double coord_Source_Y, double weight, double coord_X, double coord_Y, double sigma){
		double d=this.getDistance2(coord_Source_X, coord_Source_Y, coord_X, coord_Y);
		double exponent=d/Math.pow(sigma,2);
			
		return weight*Math.pow(Math.E, -exponent);
	}
	
	/**
	 * DataField.pointsɵݳĳһֵ
	 * @param coord_Xݳĳһx
	 * @param coord_Yݳĳһy
	 * @param sigmaӰ
	 * @returnݳиֵ
	 */
	public double getPotential(double coord_X, double coord_Y, double sigma){
		double result=0;
		DataBase db=DataBase.getInstance();
		DataPoint[] dataPoints=db.getPoints();
		
		for(int i=0,len=dataPoints.length;i<len;i++){
			DataPoint p=dataPoints[i];
			result+=this.getPotential(p.getCoord_X(), p.getCoord_Y(), p.getWeight(), coord_X, coord_Y, sigma);
		}
		return result;
	}
	
	/**
	 * ɫHLSռתΪRGBռ
	 * @param Hɫռɫ
	 * @param Lɫռ
	 * @param SɫռıͶ
	 * @return
	 */
	public static Color HLStoRGB(float H, float L, float S){
		if(H>1||H<0)	return null;
		if(S>1||S<0)	return null;
		
		float r=0,g=0,b=0;
		
		if(L<=0)	r=g=b=0;
		else if(L>=1)	r=g=b=1;
		else{
			float hh=(6*H)%6;
			int c1=(int) hh;
			float c2=hh-c1;
			float d=(L<=0.5f)?(S*L):(S*(1-L));
			float w=L+d;
			float x=L-d;
			float y=w-(w-x)*c2;
			float z=x+(w-x)*c2;
			switch(c1){
			case 0: r=w;g=z;b=x;break;
			case 1:	r=y;g=w;b=x;break;
			case 2:	r=x;g=w;b=z;break;
			case 3:	r=x;g=y;b=w;break;
			case 4:	r=z;g=x;b=w;break;
			case 5:	r=w;g=x;b=y;break;
			}
		}
		return new Color(r,g,b);
	}
}
